using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents logon failure security message
	/// defined in VistALink protocol.
	/// </summary>
	public sealed class SecurityLogonFailureResponseMessage : SecuritySimpleResponseMessage
	{
		/// <summary>
		/// VistALink message response type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string ResponseType = "AV.Logon";

		/// <summary>
		/// Default parameterless constructor. Does not specify informative error message. 
		/// Not recommended to use. 
		/// </summary>
		public SecurityLogonFailureResponseMessage() 			 
			: base( ResponseType, ResponseStatus.Failure ){}

		/// <summary>
		/// This constructor allows specyfying informative error message describing the failure. 
		/// </summary>
		/// <param name="message">Optional informative message. Expected to be human-readable.</param>
		public SecurityLogonFailureResponseMessage( string message ) 			 
			: base( ResponseType, ResponseStatus.Failure, message ){}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document.</param>
		public SecurityLogonFailureResponseMessage( XmlDocument sourceDoc ) 
			: base( ResponseType, sourceDoc )
		{
			if( _responseStatus != ResponseStatus.Failure )
				throw( new XmlParseException( SR.Exceptions.SecurityResponseFailureMsgInvalidResponseStatus( _responseStatus.ToString() ) ) );
		}
	}
}
